<?php

namespace YOOtheme;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Document\HtmlDocument;
use Joomla\CMS\Factory;

return [
    'name' => 'module_position',
    'title' => 'Module Position',
    'group' => 'system',
    'icon' => '${url:images/icon.svg}',
    'iconSmall' => '${url:images/iconSmall.svg}',
    'element' => true,
    'defaults' => [
        'layout' => 'stack',
        'breakpoint' => 'm',
    ],
    'templates' => [
        'render' => __DIR__ . '/templates/template.php',
    ],
    'transforms' => [
        'render' => function ($node) {
            /** @var CMSApplication $joomla */
            $joomla = Factory::getApplication();

            /** @var HtmlDocument $document */
            $document = $joomla->getDocument();

            $renderer = $document->loadRenderer('modules');
            $position = $node->props['content'] ?? '';

            // render module position
            if ($position && $document->countModules($position)) {
                $node->content = $renderer->render($position, [
                    'style' => 'grid' . ($node->props['layout'] === 'stack' ? '-stack' : ''),
                    'position' => $node->props, // pass grid settings to templates/position.php
                ]);
            }

            // return false, if no module position content was found
            if (empty($node->content)) {
                return false;
            }
        },
    ],
    'fields' => [
        'content' => [
            'type' => 'select-position',
            'label' => 'Position',
            'description' =>
                'Select a Joomla module position that will render all published modules. It\'s recommended to use the builder-1 to -6 positions, which are not rendered elsewhere by the theme.',
        ],
        'layout' => [
            'type' => 'select',
            'label' => 'Layout',
            'description' =>
                'Select whether the modules should be aligned side by side or stacked above each other.',
            'default' => 'sidebar',
            'options' => [
                'Stacked' => 'stack',
                'Grid' => 'grid',
            ],
        ],
        'column_gap' => [
            'label' => 'Column Gap',
            'description' => 'Set the size of the gap between the grid columns.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Medium' => 'medium',
                'Default' => '',
                'Large' => 'large',
                'None' => 'collapse',
            ],
        ],
        'row_gap' => [
            'label' => 'Row Gap',
            'description' => 'Set the size of the gap between the grid rows.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Medium' => 'medium',
                'Default' => '',
                'Large' => 'large',
                'None' => 'collapse',
            ],
        ],
        'divider' => [
            'label' => 'Divider',
            'description' => 'Show a divider between grid columns.',
            'type' => 'checkbox',
            'text' => 'Show dividers',
            'enable' => 'column_gap != \'collapse\' && row_gap != \'collapse\'',
        ],
        'breakpoint' => [
            'type' => 'select',
            'label' => 'Breakpoint',
            'description' => 'Set the breakpoint from which grid items will stack.',
            'options' => [
                'Small (Phone Landscape)' => 's',
                'Medium (Tablet Landscape)' => 'm',
                'Large (Desktop)' => 'l',
                'X-Large (Large Screens)' => 'xl',
            ],
        ],
        'vertical_align' => [
            'type' => 'checkbox',
            'label' => 'Vertical Alignment',
            'description' => 'Vertically center grid items.',
            'text' => 'Center',
        ],
        'match' => [
            'type' => 'checkbox',
            'label' => 'Match Height',
            'description' => 'Match the height of all modules which are styled as a card.',
            'text' => 'Match height',
        ],
        'position' => '${builder.position}',
        'position_left' => '${builder.position_left}',
        'position_right' => '${builder.position_right}',
        'position_top' => '${builder.position_top}',
        'position_bottom' => '${builder.position_bottom}',
        'position_z_index' => '${builder.position_z_index}',
        'blend' => '${builder.blend}',
        'margin_top' => '${builder.margin_top}',
        'margin_bottom' => '${builder.margin_bottom}',
        'maxwidth' => '${builder.maxwidth}',
        'maxwidth_breakpoint' => '${builder.maxwidth_breakpoint}',
        'block_align' => '${builder.block_align}',
        'block_align_breakpoint' => '${builder.block_align_breakpoint}',
        'block_align_fallback' => '${builder.block_align_fallback}',
        'text_align' => '${builder.text_align_justify}',
        'text_align_breakpoint' => '${builder.text_align_breakpoint}',
        'text_align_fallback' => '${builder.text_align_justify_fallback}',
        'animation' => '${builder.animation}',
        '_parallax_button' => '${builder._parallax_button}',
        'visibility' => '${builder.visibility}',
        'name' => '${builder.name}',
        'status' => '${builder.status}',
        'id' => '${builder.id}',
        'class' => '${builder.cls}',
        'attributes' => '${builder.attrs}',
        'css' => [
            'label' => 'CSS',
            'description' =>
                'Enter your own custom CSS. The following selectors will be prefixed automatically for this element: <code>.el-element</code>',
            'type' => 'editor',
            'editor' => 'code',
            'mode' => 'css',
            'attrs' => [
                'debounce' => 500,
                'hints' => ['.el-element'],
            ],
            'source' => true,
        ],
        'transform' => '${builder.transform}',
    ],
    'fieldset' => [
        'default' => [
            'type' => 'tabs',
            'fields' => [
                [
                    'title' => 'Content',
                    'fields' => ['content'],
                ],
                [
                    'title' => 'Settings',
                    'fields' => [
                        [
                            'label' => 'Grid',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'layout',
                                'column_gap',
                                'row_gap',
                                'divider',
                                'breakpoint',
                                'vertical_align',
                                'match',
                            ],
                        ],
                        [
                            'label' => 'General',
                            'type' => 'group',
                            'fields' => [
                                'position',
                                'position_left',
                                'position_right',
                                'position_top',
                                'position_bottom',
                                'position_z_index',
                                'blend',
                                'margin_top',
                                'margin_bottom',
                                'maxwidth',
                                'maxwidth_breakpoint',
                                'block_align',
                                'block_align_breakpoint',
                                'block_align_fallback',
                                'text_align',
                                'text_align_breakpoint',
                                'text_align_fallback',
                                'animation',
                                '_parallax_button',
                                'visibility',
                            ],
                        ],
                    ],
                ],
                '${builder.advanced}',
            ],
        ],
    ],
];
