<?php

namespace YOOtheme;

return [
    'name' => 'social',
    'title' => 'Social',
    'group' => 'multiple items',
    'icon' => '${url:images/icon.svg}',
    'iconSmall' => '${url:images/iconSmall.svg}',
    'element' => true,
    'container' => true,
    'width' => 500,
    'defaults' => [
        'link_style' => 'button',
        'grid' => 'horizontal',
        'grid_column_gap' => 'small',
        'grid_row_gap' => 'small',
        'image_svg_inline' => true,
        'margin_top' => 'default',
        'margin_bottom' => 'default',
    ],
    'placeholder' => [
        'children' => [
            [
                'type' => 'social_item',
                'props' => [
                    'link' => 'https://twitter.com',
                ],
            ],
            [
                'type' => 'social_item',
                'props' => [
                    'link' => 'https://facebook.com',
                ],
            ],
            [
                'type' => 'social_item',
                'props' => [
                    'link' => 'https://www.youtube.com',
                ],
            ],
        ],
    ],
    'updates' => __DIR__ . '/updates.php',
    'templates' => [
        'render' => __DIR__ . '/templates/template.php',
        'content' => __DIR__ . '/templates/content.php',
    ],
    'fields' => [
        'content' => [
            'label' => 'Items',
            'type' => 'content-items',
            'title' => 'link',
            'item' => 'social_item',
        ],
        'link_style' => [
            'label' => 'Style',
            'type' => 'select',
            'options' => [
                'Icon Link' => '',
                'Icon Button' => 'button',
                'Link' => 'link',
                'Link Muted' => 'muted',
                'Link Text' => 'text',
                'Link Reset' => 'reset',
                'Iconnav' => 'iconnav',
                'Thumbnav' => 'thumbnav',
            ],
        ],
        'grid' => [
            'label' => 'Grid',
            'type' => 'select',
            'options' => [
                'Horizontal' => 'horizontal',
                'Vertical' => 'vertical',
            ],
        ],
        'grid_vertical_breakpoint' => [
            'label' => 'Grid Breakpoint',
            'description' => 'Set the breakpoint from which grid items will align side by side.',
            'type' => 'select',
            'options' => [
                'Always' => '',
                'Small (Phone Landscape)' => 's',
                'Medium (Tablet Landscape)' => 'm',
                'Large (Desktop)' => 'l',
                'X-Large (Large Screens)' => 'xl',
            ],
            'enable' => 'grid == \'vertical\' && !$match(link_style, \'iconnav|thumbnav\')',
        ],
        'grid_column_gap' => [
            'label' => 'Column Gap',
            'description' => 'Set the size of the gap between the grid columns.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Medium' => 'medium',
                'Default' => '',
                'Large' => 'large',
                'None' => 'collapse',
            ],
            'enable' =>
                '!$match(link_style, \'iconnav|thumbnav\') || ($match(link_style, \'iconnav|thumbnav\') && grid == \'horizontal\')',
        ],
        'grid_row_gap' => [
            'label' => 'Row Gap',
            'description' => 'Set the size of the gap between the grid rows.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Medium' => 'medium',
                'Default' => '',
                'Large' => 'large',
                'None' => 'collapse',
            ],
            'enable' =>
                '!$match(link_style, \'iconnav|thumbnav\') || ($match(link_style, \'iconnav|thumbnav\') && grid == \'horizontal\')',
        ],
        'image_width' => [
            'type' => 'number',
            'attrs' => [
                'placeholder' => 'auto',
            ],
        ],
        'image_height' => [
            'type' => 'number',
            'attrs' => [
                'placeholder' => 'auto',
            ],
        ],
        'image_loading' => [
            'label' => 'Loading',
            'description' =>
                'By default, images are loaded lazy. Enable eager loading for images in the initial viewport.',
            'type' => 'checkbox',
            'text' => 'Load image eagerly',
        ],
        'link_aria_label' => [
            'label' => 'ARIA Label',
            'description' =>
                'Enter a descriptive text label to make it accessible if the link has no visible text.',
        ],
        'link_target' => [
            'label' => 'Attributes',
            'description'  => 'Optionally, open the link in a new window, treat it as download, don\'t endorse the linked page or don\'t include the referrer header.',
            'type' => 'checkbox',
            'text' => 'Open in a new window',
        ],
        'link_download' => [
            'type' => 'checkbox',
            'text' => 'Download',
        ],
        'link_rel_nofollow' => [
            'type' => 'checkbox',
            'text' => 'Nofollow',
        ],
        'link_rel_noreferrer' => [
            'type' => 'checkbox',
            'text' => 'Noreferrer',
        ],
        'image_svg_inline' => [
            'label' => 'Inline SVG',
            'description' =>
                'Inject SVG images into the page markup so that they can easily be styled with CSS.',
            'type' => 'checkbox',
            'text' => 'Make SVG stylable with CSS',
        ],
        'position' => '${builder.position}',
        'position_left' => '${builder.position_left}',
        'position_right' => '${builder.position_right}',
        'position_top' => '${builder.position_top}',
        'position_bottom' => '${builder.position_bottom}',
        'position_z_index' => '${builder.position_z_index}',
        'blend' => '${builder.blend}',
        'margin_top' => '${builder.margin_top}',
        'margin_bottom' => '${builder.margin_bottom}',
        'maxwidth' => '${builder.maxwidth}',
        'maxwidth_breakpoint' => '${builder.maxwidth_breakpoint}',
        'block_align' => '${builder.block_align}',
        'block_align_breakpoint' => '${builder.block_align_breakpoint}',
        'block_align_fallback' => '${builder.block_align_fallback}',
        'text_align' => '${builder.text_align}',
        'text_align_breakpoint' => '${builder.text_align_breakpoint}',
        'text_align_fallback' => '${builder.text_align_fallback}',
        'animation' => '${builder.animation}',
        '_parallax_button' => '${builder._parallax_button}',
        'visibility' => '${builder.visibility}',
        'name' => '${builder.name}',
        'status' => '${builder.status}',
        'source' => '${builder.source}',
        'id' => '${builder.id}',
        'class' => '${builder.cls}',
        'attributes' => '${builder.attrs}',
        'css' => [
            'label' => 'CSS',
            'description' =>
                'Enter your own custom CSS. The following selectors will be prefixed automatically for this element: <code>.el-element</code>, <code>.el-item</code>, <code>.el-link</code>',
            'type' => 'editor',
            'editor' => 'code',
            'mode' => 'css',
            'attrs' => [
                'debounce' => 500,
                'hints' => ['.el-element', '.el-item', '.el-link'],
            ],
            'source' => true,
        ],
        'transform' => '${builder.transform}',
    ],
    'fieldset' => [
        'default' => [
            'type' => 'tabs',
            'fields' => [
                [
                    'title' => 'Content',
                    'fields' => ['content'],
                ],
                [
                    'title' => 'Settings',
                    'fields' => [
                        [
                            'label' => 'Social Icons',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'link_style',
                                'grid',
                                'grid_vertical_breakpoint',
                                'grid_column_gap',
                                'grid_row_gap',
                            ],
                        ],
                        [
                            'label' => 'Image',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                [
                                    'label' => 'Width/Height',
                                    'description' =>
                                        'Setting just one value preserves the original proportions. The image will be resized and cropped automatically, and where possible, high resolution images will be auto-generated.',
                                    'type' => 'grid',
                                    'width' => '1-2',
                                    'fields' => ['image_width', 'image_height'],
                                ],
                                'image_loading',
                                'image_svg_inline',
                            ],
                        ],
                        [
                            'label' => 'Link',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'link_aria_label',
                                'link_target',
                                'link_download',
                                'link_rel_nofollow',
                                'link_rel_noreferrer',
                            ],
                        ],
                        [
                            'label' => 'General',
                            'type' => 'group',
                            'fields' => [
                                'position',
                                'position_left',
                                'position_right',
                                'position_top',
                                'position_bottom',
                                'position_z_index',
                                'blend',
                                'margin_top',
                                'margin_bottom',
                                'maxwidth',
                                'maxwidth_breakpoint',
                                'block_align',
                                'block_align_breakpoint',
                                'block_align_fallback',
                                'text_align',
                                'text_align_breakpoint',
                                'text_align_fallback',
                                'animation',
                                '_parallax_button',
                                'visibility',
                            ],
                        ],
                    ],
                ],
                '${builder.advanced}',
            ],
        ],
    ],
];
